%% Declare and define transition matrix
T=[0.2,0.1,0,0; 0.3,0.7,0.2,0; 0.5,0.2,0.5,0; 0,0,0.3,1]


%% Simulate for a large number of steps
%At each step, add the probability of arriving in state 4 (D) by the number of
%steps taken
p=[1,0,0,0]'; %initial probability vector - definitely in state 1
pD_fn_t = zeros(50,1); % keep track of probability of having reached state 4 (D)

for i=1:50
    p=T*p; %p-vector after step
    pD_fn_t(i)=p(4); %record in array
end

%plot p4 as a function of the number of steps
bar(pD_fn_t);
set(gca, 'FontSize', 20);


%% Calculate average number of steps
%probability of arriving in step i is p_4(i)-p_4(i-1)

av = pD_fn_t(1); % contribution from first step
for i=2:50
    av = av+i*(pD_fn_t(i)-pD_fn_t(i-1));
end
av